;*******************************************************************************
;   Code for application report - "VLO Library"
;*******************************************************************************
; THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR
; REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,
; INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
; FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR
; COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.
; TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET
; POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY
; INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
; YOUR USE OF THE PROGRAM.
;
; IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
; CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY
; THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT
; OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.
; EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF
; REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS
; OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF
; USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
; AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF
; YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS
; (U.S.$500).
;
; Unless otherwise stated, the Program written and copyrighted
; by Texas Instruments is distributed as "freeware".  You may,
; only under TI's copyright in the Program, use and modify the
; Program without any charge or restriction.  You may
; distribute to third parties, provided that you transfer a
; copy of this license to the third party and the third party
; agrees to these terms by its first use of the Program. You
; must reproduce the copyright notice and any other legend of
; ownership on each copy or partial copy, of the Program.
;
; You acknowledge and agree that the Program contains
; copyrighted material, trade secrets and other TI proprietary
; information and is protected by copyright laws,
; international copyright treaties, and trade secret laws, as
; well as other intellectual property laws.  To protect TI's
; rights in the Program, you agree not to decompile, reverse
; engineer, disassemble or otherwise translate any object code
; versions of the Program to a human-readable form.  You agree
; that in no event will you alter, remove or destroy any
; copyright notice included in the Program.  TI reserves all
; rights not specifically granted under this license. Except
; as specifically provided herein, nothing in this agreement
; shall be construed as conferring by implication, estoppel,
; or otherwise, upon you, any license or other right under any
; TI patents, copyrights or trade secrets.
;
; You may not use the Program in non-TI devices.
;
;*******************************************************************************
;   L. Westlund
;   Texas Instruments Inc.
;   March 2006
;   Built with Code Composer Essentials 2.0
;*******************************************************************************
 .cdecls C,LIST,    "msp430x20x2.h"

            ;Functions
            .def      TI_getRandomIntegerFromVLO
            ;Variables
            .bss TI_RandomIntegerFromVLO, 2
            .align 2
            .text

;DEVICE_TYPE .set 2                          ; 2xx devices with a Timer_A3
DEVICE_TYPE .set 3                          ; 2xx devices with a Timer_A2

 .if DEVICE_TYPE = 3                        ; For Timer_A2 devices
TACCTLX .set TACCTL0
TACCRX .set TACCR0
 .else
TACCTLX .set TACCTL2
TACCRX .set TACCR2
 .endif
 
;-------------------------------------------------------------------------------
;TI_getRandomIntegerFromADC
;           returns: r12
;-------------------------------------------------------------------------------
;            mov.w   #16,       r15          ; loop counter
;            mov.w   #INCH_10,  &ADC10CTL1
;            mov.w   #SREF_1 + ADC10SHT_1 + REFON + ADC10ON, &ADC10CTL0
;adcloop     bis.w   #ENC + ADC10SC, &ADC10CTL0
;sampling    bit.w   #ADC10BUSY, &ADC10CTL1
;            jnz     sampling
;            bit.w   #0x01,     &ADC10MEM
;            rrc.w   r12
;            dec.w   r15
;            jnz     adcloop
;            ret
;-------------------------------------------------------------------------------
TI_getRandomIntegerFromVLO
;           returns: r12
;-------------------------------------------------------------------------------
            push.w  r11                     ; r11 preserved
            bis.b   #LFXT1S_2, &BCSCTL3     ; ACLK = VLO
            mov.w   #CM_1 + CCIS_1 + CAP,   &TACCTLX ; CAP, ACLK
            mov.w   #TASSEL_2 + MC_2, &TACTL; SMCLK, cont-mode, don't clear
            mov.w   #16,       r15          ; loop counter = 16
            clr.w   r12                     ; return value cleared
            clr.w   r13                     ; ACLK divider randomness
mainLoop    mov.w   #5,        r14          ; sub loop counter
            clr.w   r11                     ; majority vote holder
capture     bit.w   #CCIFG,    &TACCTLX       ; test for capture
            jz      capture
            bic.w   #CCIFG,    &TACCTLX       ; capture occured, clear flag
            bit.w   #0x01,     &TACCRX        ; test LSB of captured time
            jz      zero                    ; of LSB is zero, jump
            inc.w   r11                     ; if not, add  one to R11 to count 1s
zero        dec.w   r14                     ; decrement majority vote counter
            jnz     capture                 ; if 3 bits aren't counted for, loop
            rra.w   r12                     ; make space for the new bit
            cmp.w   #0x03, r11              ; see if there are 2 or more 1s
            jge     one
            bic.w   #0x8000, r12            ; if not, clear the new bit in r12
            jmp     done
one         bis.w   #0x8000, r12            ; if so, set the new bit in r12
done
            ;-------------------            ; xor the ACLK divider section of the BCSCTL1
            mov.w   r12,       r13
            swpb    r13
            rra.w   r13
            rra.w   r13
            rra.w   r13
            and.w   #0x30,     r13
            xor.b   r13,       &BCSCTL1
            ;-------------------            ; add to the RSEL bits to change DCO speed
            add.b   #0x05,     &BCSCTL1
            and.b   #0x3F,     &BCSCTL1
            ;-------------------            ; XOR DCO Mod bits
            xor.b   #0x1F,     &DCOCTL
            ;-------------------
            dec.w   r15
            jnz     mainLoop
            pop.w   r11
            ret

            .end
             